## Combined methods plot - except Shellie's image
## Author: Jim Stevens
## Date: 29/04/2024
## Version: 4.3.3

#### Housekeeping ####
rm(list=ls())

library(tidyverse)
library(cowplot)

load("./Outputs/Intensity_min_max_selection.rdata")
mm <- NULL
mm$Vmax <- 30.12732
mm$Km <- 361.0721
mm$Rd <- 1.465186
mmfun <- function(x){mm$Vmax*x/(mm$Km+x-mm$Rd)}

a1

a=unique(0.05883648)
b=unique(-2.56339)
c=unique(0.0004096003)
gomfun <- function(x){a*exp(-b*exp(-c*x))-0.04}
load("./Outputs/Setpoint_analysis.rdata")
fqplot <- fqplot+stat_function(fun=gomfun) 

load("./Outputs/kpplot.rdata")
load("./Outputs/kiplot.rdata")

ki <- plot_grid(kpplot,kiplot,
          align="h",
          labels=c("C","D"),
          nrow=1,
          rel_widths=c(0.7,0.5))
ki
#save_plot("./Outputs/Final Plots/Supplementary Information/PI Constants Analysis.png",ki)

af <- plot_grid(a1+theme(axis.title.x=element_blank(),
                         axis.text.x=element_blank()),
                fqplot,
                nrow=2,
                labels=c("A","B"),
                align="v",
                rel_heights=c(0.7,0.8))
af

save_plot("./Outputs/Final Plots/Fig_3_Methods.png",
          af,base_height=8,base_width = 5)
# squarish plots at h = 8, b = 5)
# oblong plots at h = 8, b = 8)

